<?php

class LCW_Live_Score_Widget extends WP_Widget {

	/**
	 * Sets up the widgets name etc
	 */
	public function __construct() {
		$widget_ops = array( 
			'classname'   => 'lcw_live_score_widget',
			'description' => 'Recent Live, Completed, upcoming Matches',
		);
		parent::__construct( 'lcw_live_score_widget', 'Recent Live, Completed, upcoming Matches', $widget_ops );
	}

	/**
	 * Outputs the content of the widget
	 *
	 * @param array $args
	 * @param array $instance
	 */
	public function widget( $args, $instance ) {

		if ( isset( $instance[ 'completed_matches' ] ) ) {

			$completed_matches = $instance[ 'completed_matches' ];
		}
		else {

			$completed_matches = 10;
		}
		if ( isset( $instance[ 'upcoming_matches' ] ) ) {

			$upcoming_matches = $instance[ 'upcoming_matches' ];
		}
		else {

			$upcoming_matches = 5;
		}
		if ( isset( $instance[ 'live_matches' ] ) ) {

			$live_matches = $instance[ 'live_matches' ];
		}
		else {

			$live_matches = 3;
		}
		global $live_score;
		
		$live_content         = $live_score->lcw_get_content('matches?completedLimit=0&inProgressLimit='.$live_matches.'&upcomingLimit=0' );
		$live_contents        = utf8_encode( $live_content ); 
        $live_matches_list    = json_decode( $live_contents);
        $live_matches         = $live_matches_list->matchList->matches;
		
		$complete_content         = $live_score->lcw_get_content('matches?completedLimit='.$completed_matches.'&inProgressLimit=0&upcomingLimit=0' );
		$complete_contents        = utf8_encode( $complete_content ); 
        $complete_matches_list    = json_decode( $complete_contents);
        $matches        		  = $complete_matches_list->matchList->matches;
		
		$upcomming_content   	  = $live_score->lcw_get_content('matches?completedLimit=0&inProgressLimit=0&upcomingLimit='.$upcoming_matches );
		$upcomming_contents       = utf8_encode( $upcomming_content ); 
        $upcomming_matches_list   = json_decode( $upcomming_contents);
        $upcomming_matches        = $upcomming_matches_list->matchList->matches;		
        ?>
            	<div class="custom-widget ulcwp-widget">
            		<div class="ulcwp-widget-inner">
						<div class="ulcwp-widget-tabs">
							<ul class="ulcwp-tabs">
								<li class="tab-link current" data-tab="tab-1">
									<span>
										<?php 
								          	echo apply_filters('lcw_live_widget_text', 'Live'); 
								        ?>
							        	
							        </span>
							    </li>
								<li class="tab-link" data-tab="tab-2"><span>UpComing</span></li>
								<li class="tab-link" data-tab="tab-3"><span>Recent</span></li>
							</ul>
							<div class="ulcwp-tabs-contents">
								<div id="tab-1" class="tab-content current">
									<?php 

						    			require_once LCW_LIVE_SCORE_ROOT_PATH . '/templates/widget/live-matches-widget.php';
						    			live_matches_widget($live_matches); 
						    		?>
							    </div>
							    <div id="tab-2" class="tab-content">
							    	
									<?php 

								    	require_once LCW_LIVE_SCORE_ROOT_PATH . '/templates/widget/upcomming-matches-widget.php';
								    	upcomming_matches_widget($upcomming_matches); 
								    ?>
							    </div>
							    <div id="tab-3" class="tab-content">
							    	<?php 

									    require_once LCW_LIVE_SCORE_ROOT_PATH . '/templates/widget/complete-matches-widget.php';
									    complete_matches_widget($matches); 
									?>

							    </div>
							</div>
			   		</div>
			   	</div>
			</div>
		<?php
			
		}

	/**
	 * Outputs the options form on admin
	 *
	 * @param array $instance The widget options
	 */
	public function form( $instance ) {
		if ( isset( $instance[ 'completed_matches' ] ) ) {

			$completed_matches = $instance[ 'completed_matches' ];
		}
		else {

			$completed_matches = 10;
		}
		if ( isset( $instance[ 'upcoming_matches' ] ) ) {

			$upcoming_matches = $instance[ 'upcoming_matches' ];
		}
		else {

			$upcoming_matches = 5;
		}
		if ( isset( $instance[ 'upcoming_matches' ] ) ) {

			$live_matches = $instance[ 'live_matches' ];
		}
		else {

			$live_matches = 5;
		}
	?>
		<p>
			<label for="<?php echo $this->get_field_id( 'upcoming_matches' ); ?>">
				<?php _e( '# of Live Matches' ); ?>
			</label> 
			<input class="widefat" id="<?php echo $this->get_field_id( 'live_matches' ); ?>" name="<?php echo $this->get_field_name( 'live_matches' ); ?>" type="text" value="<?php echo esc_attr( $live_matches ); ?>" />
		</p>
		<p>
			<label for="<?php echo $this->get_field_id( 'completed_matches' ); ?>"><?php _e( '# of Completed Matches' ); ?></label> 
			<input class="widefat" id="<?php echo $this->get_field_id( 'completed_matches' ); ?>" name="<?php echo $this->get_field_name( 'completed_matches' ); ?>" type="text" value="<?php echo esc_attr( $completed_matches ); ?>" />
		</p>
		<p>
			<label for="<?php echo $this->get_field_id( 'upcoming_matches' ); ?>">
				<?php _e( '# of Upcoming Matches' ); ?>
			</label> 
			<input class="widefat" id="<?php echo $this->get_field_id( 'upcoming_matches' ); ?>" name="<?php echo $this->get_field_name( 'upcoming_matches' ); ?>" type="text" value="<?php echo esc_attr( $upcoming_matches ); ?>" />
		</p>
		<?php
	}

	/**
	 * Processing widget options on save
	 *
	 * @param array $new_instance The new options
	 * @param array $old_instance The previous options
	 */
	public function update( $new_instance, $old_instance ) {
		$instance = array();
		$instance['live_matches'] = ( ! empty( $new_instance['live_matches'] ) ) ? strip_tags( $new_instance['live_matches'] ) : '';
		$instance['upcoming_matches'] = ( ! empty( $new_instance['upcoming_matches'] ) ) ? strip_tags( $new_instance['upcoming_matches'] ) : '';
		$instance['completed_matches'] = ( ! empty( $new_instance['completed_matches'] ) ) ? strip_tags( $new_instance['completed_matches'] ) : '';
		return $instance;
	}
}