<?php
/*
    Exit if accessed directly
*/
if ( ! defined( 'ABSPATH' ) ) exit;
    if ( ! class_exists( 'LCW_Live_Score' ) ) {

      class LCW_Live_Score extends LCW_Base_Class{

        
        /**
         * Setup the plugin data
         *
         * @since 1.0.0
        */
        public function __construct() {

          $this->add_action( 'widgets_init', 'lcw_score_widget' );
          $this->add_action( 'admin_menu', 'lcw_score_admin_menus');
          $this->add_action( 'wp_loaded', 'lcw_score_front_reg_scripts');
          $this->add_action( 'admin_enqueue_scripts', 'lcw_score_admin_scripts');
          $this->add_action( 'admin_enqueue_scripts', 'lcw_score_admin_styles');
          $this->add_action( 'wp_enqueue_scripts', 'lcw_score_front_scripts');
          $this->add_action( 'wp_enqueue_scripts', 'lcw_score_front_styles');
          $this->add_action( 'init', 'lcw_score_localizations');
          $this->add_action( 'wp_head', 'lcw_add_css_code');
          $this->add_action( 'init', 'lcw_score_mapping'  );
          $this->add_action( 'admin_init', 'lcw_score_matches_mapping'  );
          $this->add_filter( 'lcw_fixture_text', 'lcw_add_fixture_text');
          $this->add_filter( 'lcw_completed_tab_text' , 'lcw_add_completed_tab_text');
          $this->add_filter( 'lcw_stats_tab_text' , 'lcw_add_stats_tab_text');
          $this->add_filter( 'lcw_upcomming_tab_text' , 'lcw_add_upcomming_tab_text');
          $this->add_filter( 'lcw_series_text'        , 'lcw_add_series_text');
          $this->add_filter( 'lcw_completed_widget_text', 'lcw_add_completed_widget_text');
          $this->add_filter( 'lcw_upcomming_widget_text', 'lcw_add_upcomming_widget_text');
          $this->add_filter( 'lcw_live_widget_text', 'lcw_add_live_widget_text');
          $this->register_shortcode( 'series', 'lcw_score_series_shortcode' );
          $this->register_shortcode( 'series-matches', 'lcw_score_series_matches_shortcode' );
          $this->register_shortcode( 'country-matches', 'lcw_score_country_matches_shortcode' );
          $this->register_shortcode( 'match-detail', 'lcw_match_detail_shortcode' );
          $this->register_shortcode( 'player-stats', 'lcw_player_stats_shortcode' );
          $this->register_shortcode( 'team-data', 'lcw_team_data_shortcode' );
          $this->register_shortcode( 'lcw-teams', 'lcw_teams_shortcode' );
          $this->add_action('init', 'lcw_feed');
          $this->add_filter('document_title_parts', 'lcw_change_document_title_parts' );
          $this->add_action('init','lcw_rewrite_rules');
          $this->add_filter('pre_get_document_title', 'lcw_change_document_title', 999,1 );
          $this->add_ajax ( 'lcw_save_timezone',    'lcw_save_timezone');
          $this->add_ajax ( 'lcw_load_more_matches', 'lcw_load_more_matches');
          $this->register_shortcode( 'lcw-fixtures', 'lcw_score_fixtures_shortcode' );
          $this->register_shortcode( 'matches-sliders', 'lcw_matches_sliders_shortcode' );          
          $this->register_shortcode( 'series-standings', 'lcw_series_standings' );
          $this->register_shortcode( 'lcw-rankings', 'lcw_load_ranking_shortcode' );
          $this->add_filter( 'wpseo_opengraph_title', 'lcw_change_document_title', 10, 1 ); 
          $this->add_filter( 'wpseo_opengraph_desc', 'lcw_change_document_title', 10, 1 ); 
          $this->add_filter( 'wpseo_canonical', 'lcw_change_canonical' );
          $this->add_filter( 'wpseo_opengraph_url', 'lcw_change_canonical' );
          $this->add_filter ( 'wp_resource_hints','load_api_resource', 10, 2);
          $this->add_filter('the_title','lcw_change_page_title');

          //$this->add_filter( 'wpseo_metadesc', 'ulcw_add_metadesc', 10, 1 ); 
          //$this->add_filter( 'wpseo_title', 'ulcw_add_metadesc', 10, 1 ); 
        }
        function lcw_load_more_matches(){
          $type    = $_POST['type'];
          $pagenum = $_POST['page'];
          $layout  = isset( $_POST['layout'] ) ? $_POST['layout'] : '';
          $col_per_row = get_option( 'col_per_row' );
          if( empty( $col ) ){

            $col = $col_per_row;

          }
          if(!empty($_POST['status'])){

            $series_status = $_POST['status'];
          }
          else{

            $series_status = 'upcoming';
          }
          
          if($type == 'series'){

            $series_content     = $this->lcw_get_content('{"query":"query seriesPriority($tab: String, $filter: String, $country: String, $format: String, $page: Int) {\\n  seriesPriority(tab: $tab, filter: $filter, country: $country, format: $format, page: $page) {\\n    tourName\\n    seriesSearchNameForES\\n    tourID\\n    league\\n    seriesStartDate\\n    seriesEndDate\\n    T20count\\n    matchLevel\\n    Odicount\\n    Testcount\\n  }\\n}\\n","variables":{"tab":"'.$series_status.'","filter":"","country":"","format":"","page":'.$pagenum.'}}');
          
          
            $contents           = utf8_encode($series_content); 
            $series             = json_decode($contents);
                       
            require_once LCW_LIVE_SCORE_ROOT_PATH . '/sections/ajax-series.php';
                

          }elseif ($type == 'matches') {
              
              if(!empty($_POST['status'])){

                $match_status = $_POST['status'];
              }
              else{

                $match_status = 'upcoming';
              }
              $matches_content  = $this->lcw_get_content('{"query":"query newSchedule($type: String!, $status: String!, $page: Int!)\\n{\\nnewSchedule(type: $type, status: $status, page: $page){\\n seriesView\\n seriesAvailable\\n seriesID\\n matchType\\n seriesName \\n   matches{\\n    seriesID\\n \\n   league\\n   currentinningsNo\\n   currentInningsTeamName\\n   seriesName\\n   homeTeamName\\n   awayTeamName\\n   toss\\n   startEndDate\\n   matchStatus\\n   matchID\\n   matchType\\n   statusMessage\\n   matchNumber\\n   venue\\n   matchResult\\n     teamsWinProbability {\\n     homeTeamShortName\\n     homeTeamPercentage\\n     awayTeamShortName\\n     awayTeamPercentage\\n     tiePercentage\\n   }\\n    \\n      matchScore {\\n     teamShortName\\n     teamID\\n     teamFullName\\n     teamScore {\\n       inning\\n       inningNumber\\n       battingTeam\\n       runsScored\\n       wickets\\n       overs\\n       runRate\\n       battingSide\\n       teamID\\n       battingTeamShortName\\n       declared\\n       folowOn\\n     }\\n     }\\n    \\n   startDate\\n    \\n   playerID\\n   playing11Status\\n   probable11Status\\n   playerOfTheMatch\\n    \\n   firstInningsTeamID\\n   secondInningsTeamID\\n   thirdInningsTeamID\\n    \\n   fourthInningsTeamID\\n     league\\n    \\n   }\\n \\n}\\n}\\n","variables":{"type":"all","status":"'.$match_status.'","page":'.$pagenum.'}}');
              $matches_contents  = utf8_encode( $matches_content ); 
              $matches_list      = json_decode( $matches_contents);
              
              $matches    = $matches_list->data->newSchedule;
              require_once LCW_LIVE_SCORE_ROOT_PATH . '/sections/ajax-matches.php';
          }
          
          die();
        }
        public function lcw_series_standings($atts)
        {
          extract(shortcode_atts(
            array(

              'series_id'       => -1,

            ), $atts));

            
           /* $standings_content    = $this->lcw_get_content('series/standings/'.$series_id.'?format=json' );
            $standings_contents   = utf8_encode( $standings_content ); 
            $standings_list       = json_decode( $standings_contents);*/
            require_once LCW_LIVE_SCORE_ROOT_PATH . '/templates/standings.php';

            $content = lcw_load_standings( $series_id );
            return $content;
            
        }
        
        public function ulcw_add_metadesc( $str ) {
          
          if( is_page( 'match-page' ) ){
            
            if( get_query_var( 'series' ) && get_query_var( 'match' )){

              $series_id = get_query_var( 'series' );
              $match_id  = get_query_var( 'match' );
              $match_detail_content    =  $this->lcw_get_content('matches/'.$series_id.'/'.$match_id.'/live?format=json' );
              $match_detail_contents   =  utf8_encode( $match_detail_content ); 
              $match_detail_list       =  json_decode($match_detail_contents);
              $keyword = str_replace('Men', '',$match_detail_list->liveMatch->matchDetail->homeTeam->name).' vs '.str_replace('Men', '',$match_detail_list->liveMatch->matchDetail->awayTeam->name).'. '.$match_detail_list->liveMatch->matchDetail->homeTeam->shortName.' vs '.$match_detail_list->liveMatch->matchDetail->awayTeam->shortName.' ';
              return $keyword.'| Follow Live Cricket Score and Streaming for '.$match_detail_list->liveMatch->matchDetail->homeTeam->shortName.' vs '.$match_detail_list->liveMatch->matchDetail->awayTeam->shortName.' '.$match_detail_list->liveMatch->matchDetail->matchName.' - '.$match_detail_list->liveMatch->matchDetail->localStartDate.' '. $match_detail_list->liveMatch->matchDetail->localStartTime .'  on Gifincric.com';
            }
              
          }elseif( is_page('matches' ) ){
                  
                  $series = get_query_var( 'series' );
                  
                  $matches_content           =  $this->lcw_get_content('matches/'.$series.'/?completedLimit=1&inProgressLimit=1&upcomingLimit=1&format=json');
                  $matches_contents          =  utf8_encode( $matches_content ); 
                  $matches_detail_list       =  json_decode( $matches_contents);
                  $series_name =  $matches_detail_list->matchList->matches[0]->series->shortName;
                   
                  $newtitle = $series_name.' Live Score, Points Table, Teams , News and matches';
                   return $newtitle;
          }
          elseif( is_page('match' ) ){
                  
                  $match_id = get_query_var( 'match-id' );
                  $psl_content            = $this->lcw_get_content_psl( home_url('matches_json/'.$match_id.'.json') );
                  $psl_contents       = utf8_encode( $psl_content ); 
                  $pslmatches_list    = json_decode( $psl_contents);
                   
                  $newtitle = $pslmatches_list->Teams->{ $pslmatches_list->Matchdetail->Team_Home }->Name_Short .' vs '.$pslmatches_list->Teams->{ $pslmatches_list->Matchdetail->Team_Away }->Name_Short.' Live Score | '.$pslmatches_list->Matchdetail->Series->Tour_Name.' Live Score, Points Table, Teams , News and matches';
                   return $newtitle;
          }elseif( is_page('ipl-live-score' ) ){

                  $match_id             = get_query_var( 'match' );
                  $match_info           = $this->lcw_get_content_psl( home_url('matches_json/own_'.$match_id.'.json?nocache'));

                  $match_info_contents  = utf8_encode( $match_info ); 

                  $score_info           = json_decode( $match_info_contents );
                   
                  $title_parts['title'] = $score_info->response->short_title. ' Live Score, Points Table, Teams , News , stats and matches |'.get_bloginfo( 'name');
          }else{

                  return $str;
                }
        }
        public function load_api_resource( $hints, $relation_type ){

          if ( 'dns-prefetch' === $relation_type) {
  
            $hints[] = '//cricket.com/apiv2';
          }
          else if ( 'preconnect' === $relation_type) {
            
            $hints[] = '//cricket.com/apiv2';
          }
            return $hints;
        }
        public function lcw_change_canonical($url) {
           
          if( get_query_var( 'series' ) ){

              $series_id = get_query_var( 'series' );

          }else{

            $series_id = '';
          }
          if( get_query_var( 'status' ) ){

              $status = get_query_var( 'status' );

          }else{

            $status = 'completed';
          }
          if( get_query_var( 'match-id' ) ){

            $match_id = get_query_var( 'match-id' );

          }else{

            $match_id = '';
          }
          
          if( get_query_var( 'player' ) ){

              $player_id = get_query_var( 'player-name' );

          }
          if( get_query_var( 'team-name' ) ){

              $team_name = get_query_var( 'team-name' );

          }
          if( get_query_var( 'match-name' ) ){

              $match_name = get_query_var( 'match-name' );

          }
          else{

            $match_name = "";

          }
          if( get_query_var( 'team-id' ) ){

              $team_id = get_query_var( 'team-id' );

          }
          if( get_query_var( 'type' ) ){

              $type = get_query_var( 'type' );
          }
          if( is_page('match-center' ) ){
              
              //$match_name = get_query_var( 'match-name' );
              $url = home_url('live-score/'.$match_name.'/'.$match_id.'/'.$status.'/');
              
           }elseif(is_page('player-stats')){
            
              $url = home_url('stats/'.$player_id.'/'.$type.'/');

          }elseif(is_page('matches')){
            
            $series      = get_query_var( 'series' );
            $series_name = get_query_var( 'series-name' );
            $status      = get_query_var( 'status' );
            $url         = home_url($series_name.'/'.$series.'/'.$type.'/');
            
          }
          elseif(is_page('team')){
            
            $url = home_url('team/'.$team_name.'/'.$team_id.'/');
            

          }
          elseif(is_page('match')){
            
            $teams = get_query_var( 'teams-name' );
            $url   = home_url('match/'.$teams.'/'.get_query_var( 'match-id' ).'/');
            
          }
          
          return $url;
        }
        public function lcw_matches_sliders_shortcode($atts){
              if( !$this->check_license_validation() ){
              
                   return 'Sorry! Your license is invalid.Please <a href="http://ulcwp.com/pricing-plans/">purchase Plugin copy</a> and get valid license!';
              }
              ob_start();
              extract(shortcode_atts(
                array(
                 
                  'upcoming'        => 3,
                  'live'            => 3,
                  'completed'       => 3

                ), $atts));
                
                 $featured_content        = $this->lcw_get_content('{"query":"query featuredMatches {\\n  featurematch {\\n    criclyticsButtonFlags {\\n      featuredSeriesName\\n      isFinalFour\\n      isPlayerIndex\\n      tourID\\n      seriesName\\n      frcStartTime\\n    }\\n    IPLpolling {\\n      name\\n      isPolling\\n      display\\n      isAuctionStarted\\n      isCompleted\\n    }\\n    displayFeatureMatchScoreCard\\n    seriesID\\n    currentinningsNo\\n    currentInningteamID\\n    currentInningsTeamName\\n    seriesName\\n winningTeamID\\n    homeTeamName\\n    awayTeamName\\n    toss\\n    startEndDate\\n    matchStatus\\n    matchID\\n    matchType\\n    statusMessage\\n    phaseOfInningFlag\\n    matchNumber\\n    venue\\n    matchResult\\n    startDate\\n    playerOfTheMatch\\n    playerofTheMatchTeamShortName\\n    playing11Status\\n    probable11Status\\n    playerID\\n    firstInningsTeamID\\n    secondInningsTeamID\\n    thirdInningsTeamID\\n    teamsWinProbability {\\n      homeTeamShortName\\n      homeTeamPercentage\\n      awayTeamShortName\\n      awayTeamPercentage\\n      tiePercentage\\n    }\\n    fourthInningsTeamID\\n    matchScore {\\n      teamShortName\\n      teamID\\n      teamFullName\\n      teamScore {\\n        inning\\n        inningNumber\\n        battingTeam\\n        runsScored\\n        wickets\\n        overs\\n        runRate\\n        battingSide\\n        teamID\\n        battingTeamShortName\\n        declared\\n        folowOn\\n      }\\n    }\\n    teamsWinProbability {\\n      homeTeamShortName\\n      homeTeamPercentage\\n      awayTeamShortName\\n      awayTeamPercentage\\n      tiePercentage\\n    }\\n    isCricklyticsAvailable\\n    isLiveCriclyticsAvailable\\n    isAbandoned\\n    currentDay\\n    currentSession\\n  }\\n}\\n","variables":{}}');
                  
                  $matches_list   = json_decode( $featured_content);
                  $matches        = $matches_list->data->featurematch;
                  require_once LCW_LIVE_SCORE_ROOT_PATH . '/templates/matches-sliders.php';
                  $content        = lcw_load_sliders( $matches );
                  return $content;
        }
        public function lcw_save_timezone( )
        {
          $timezone = $_POST['timezone'];
          setcookie( 'timezone', $timezone,time()+( 10 * 365 * 24 * 60 * 60),'/','gifincric.com' );
          die();
        }
        public function lcw_get_content_psl( $segment ){
            
            $response = wp_remote_get( $segment,array(
                                        'timeout'     => 120,
                                    ) ); 
            $data = wp_remote_retrieve_body($response);

            return $data;
        }       
        public function lcw_teams_shortcode( )
        {
          if( !$this->check_license_validation() ){
              
              return 'Sorry! Your license is invalid.Please <a href="http://ulcwp.com/pricing-plans/">purchase Plugin copy</a> and get valid license!';

          }
          $teams_content   = $this->lcw_get_content('{"query":"query {\\n  teamDiscoveryV2{\\n    international{\\n      mens{teamID\\n      teamName\\n        teamShortName\\n        odiRanking\\n        testRanking\\n        t20Ranking\\n      }\\n       womens{teamID\\n      teamName\\n        teamShortName\\n        odiRanking\\n        testRanking\\n        t20Ranking\\n      }\\n    }\\n    otherLeagues{\\n      ipl{\\n        teamID\\n        teamName\\n        trophy_details\\n        teamShortName\\n      }\\n      bbl{\\n        teamID\\n        teamShortName\\n        teamName\\n        trophy_details\\n      }\\n      cpl{\\n        teamID\\n        teamName\\n        teamShortName\\n        trophy_details\\n      }\\n      psl{\\n        teamID\\n        teamName\\n        teamShortName\\n        trophy_details\\n      }\\n    }\\n  }\\n}\\n","variables":{}}');
                  
              $teams      = json_decode( $teams_content);
              $teams_list = $teams->data->teamDiscoveryV2;
              require_once LCW_LIVE_SCORE_ROOT_PATH . '/templates/global-teams.php';
              $content    = lcw_load_teams( $teams_list );
              return $content;
        }
        public function lcw_team_data_shortcode( $atts )
        {
            if( !$this->check_license_validation() ){
              
                   return 'Sorry! Your license is invalid.Please <a href="http://ulcwp.com/pricing-plans/">purchase Plugin copy</a> and get valid license!';
              }
              ob_start();
              extract(shortcode_atts(
                array(
                 
                  'team_id'         => 5,
                  
                ), $atts));
              if( get_query_var('team-id') ){

                $t_id = get_query_var('team-id');

              }else{

                $t_id = $team_id;

              }
              $teamRecentForm_content        = $this->lcw_get_content('{"query":"query teamRecentForm($teamID: String) {\\n  teamRecentForm(teamID: $teamID) {\\n    hideTabs\\n    odi {\\n      winLost\\n      scoreCard {\\n        win\\n        venue\\n        matchResult\\n        matchType\\n        matchNumber\\n        matchStatus\\n        winningTeamID\\n        startDate\\n        matchID\\n        matchScore {\\n          teamShortName\\n          teamID\\n          teamFullName\\n          teamScore {\\n            inning\\n            inningNumber\\n            battingTeam\\n            runsScored\\n            wickets\\n            overs\\n            runRate\\n            battingSide\\n            teamID\\n            battingTeamShortName\\n            declared\\n            folowOn\\n          }\\n        }\\n      }\\n    }\\n    t20 {\\n      winLost\\n      scoreCard {\\n        win\\n        venue\\n        matchResult\\n        matchType\\n        matchNumber\\n        matchStatus\\n        winningTeamID\\n        startDate\\n        matchID\\n        matchScore {\\n          teamShortName\\n          teamID\\n          teamFullName\\n          teamScore {\\n            inning\\n            inningNumber\\n            battingTeam\\n            runsScored\\n            wickets\\n            overs\\n            runRate\\n            battingSide\\n            teamID\\n            battingTeamShortName\\n            declared\\n            folowOn\\n          }\\n        }\\n      }\\n    }\\n    test {\\n      winLost\\n      scoreCard {\\n        win\\n        venue\\n        matchResult\\n        matchType\\n        matchNumber\\n        matchStatus\\n        winningTeamID\\n        startDate\\n        matchID\\n        matchScore {\\n          teamShortName\\n          teamID\\n          teamFullName\\n          teamScore {\\n            inning\\n            inningNumber\\n            battingTeam\\n            runsScored\\n            wickets\\n            overs\\n            runRate\\n            battingSide\\n            teamID\\n            battingTeamShortName\\n            declared\\n            folowOn\\n          }\\n        }\\n      }\\n    }\\n  }\\n}\\n","variables":{"teamID":"'.$t_id.'"}}');
                  
              $matches_list   = json_decode( $teamRecentForm_content);
              $matches        = $matches_list->data->teamRecentForm;
              require_once LCW_LIVE_SCORE_ROOT_PATH . '/templates/team-data.php';
              $content        = lcw_load_team_matches( $matches );
              return $content;

        }
        public function lcw_load_ranking_shortcode()
        {
            if( !$this->check_license_validation() ){
                
                return 'Sorry! Your license is invalid.Please <a href="http://ulcwp.com/pricing-plans/">purchase Plugin copy</a> and get valid license!';
            }
            

            $ranking_odi_content  = $this->lcw_get_content_psl('https://www.sportsadda.com/cricket/static/json/iccranking-odi-team.json');
            $ranking_odi_contents  = utf8_encode( $ranking_odi_content ); 
            $ranking_odi_list      = json_decode( $ranking_odi_contents);

            require_once LCW_LIVE_SCORE_ROOT_PATH . '/templates/teams-ranking.php';
            $content        = lcw_load_ranking( $ranking_odi_list,$this );
            return $content;

        }
        public function lcw_score_fixtures_shortcode( $atts ){
            
              if( !$this->check_license_validation() ){
              
                   return 'Sorry! Your license is invalid.Please <a href="http://ulcwp.com/pricing-plans/">purchase Plugin copy</a> and get valid license!';
              }

              ob_start();
              extract(shortcode_atts(
                array(
                 
                  'status'        => 'upcoming',

                ), $atts));
                  if(get_query_var('status')){

                    $match_status = get_query_var('status');
                  }
                  else{

                    $match_status = $status;
                  }
                  $matches_content  = $this->lcw_get_content('{"query":"query schedule($type: String!, $status: String!, $page: Int!) {\\n  newSchedule(type: $type, status: $status, page: $page) {\\n    matches {\\n      playerOfTheMatchdDetails {\\n        playerID\\n        playerTeamID\\n        playerName\\n        batsman {\\n          batsmanBalls\\n          batsmanRuns\\n          isNotOut\\n        }\\n        bowler {\\n          bowlerWickets\\n          bowlerConceeded\\n          bowlerOvers\\n        }\\n      }\\n      winningTeamID\\n      userNotification\\n      matchenddate\\n      seriesName\\n      seriesID\\n      currentinningsNo\\n      toss\\n      startEndDate\\n      matchStatus\\n      matchID\\n      matchType\\n      statusMessage\\n      matchNumber\\n      venue\\n      currentDay\\n      currentSession\\n      matchResult\\n      startDate\\n      playerOfTheMatch\\n      playerofTheMatchTeamShortName\\n      playerID\\n      isCricklyticsAvailable\\n      isLiveCriclyticsAvailable\\n      playing11Status\\n      probable11Status\\n      isAbandoned\\n      teamsWinProbability {\\n        homeTeamShortName\\n        homeTeamPercentage\\n        awayTeamShortName\\n        awayTeamPercentage\\n        tiePercentage\\n      }\\n      matchScore {\\n        teamFullName\\n        teamID\\n        teamShortName\\n        teamScore {\\n          inning\\n          inningNumber\\n          runsScored\\n          wickets\\n          overs\\n          runRate\\n          declared\\n          folowOn\\n        }\\n      }\\n    }\\n    seriesID\\n    matchType\\n    seriesName\\n    seriesView\\n    league\\n    seriesAvailable\\n  }\\n}","variables":{"type":"all","status":"'.$match_status.'","page":0}}');
                  $matches_contents  = utf8_encode( $matches_content ); 
                  $matches_list      = json_decode( $matches_contents);
                  
                  $matches    = $matches_list->data->newSchedule;
                  require_once LCW_LIVE_SCORE_ROOT_PATH . '/templates/fixtures.php';
                  $content        = lcw_load_fixtures( $matches );
                  return $content;
          }
        public function lcw_get_user_timezone( $current,$format ){
            
            if( isset($_COOKIE['timezone']) ){

              $date = new DateTime( $current );

              $date->setTimezone( new DateTimeZone( $_COOKIE['timezone'] ) );

              return $date->format( $format );

            }else{

              return false;
            }
        }
        
        public function lcw_get_user_country( ){
            
            if( isset($_COOKIE['country_id']) ){

              return $_COOKIE['country_id'];

            }else{

              return false;
            }
        }
        /**
         * Add widget to  Admin  
         *
         * @access public
         * @param void
         * @return void
         * @since 1.0.0
        */
        public function lcw_score_widget( ){
          register_widget( 'lcw_live_score_widget' );
          register_widget( 'lcw_series_widget' );
        }
        
        /**
         * Add Admin Menu 
         *
         * @access public
         * @param void
         * @return void
         * @since 1.0.0
        */
        public static function lcw_score_admin_menus() {

          add_menu_page( LCW_LIVE_SCORE_PLUGIN_NAME, __( LCW_LIVE_SCORE_PLUGIN_NAME , 'emoji-reaction-settings' ), 'publish_posts', 'lcw-score-settings', array(
           __CLASS__,
           'lcw_score_plugin_settings_page'

         ), plugins_url( 'images/live-score.png', dirname(__FILE__)));


        }
        /**
         * Add Settings Page
         *
         * @access public
         * @param void
         * @return void
         * @since 1.0.0
        */
        public static function lcw_score_plugin_settings_page() {

          require_once LCW_LIVE_SCORE_ROOT_PATH . '/admin-pages/live-score-settings.php';
        }
        /**
         * Setup localization 
         * @access public
         * @param void
         * @since 1.0.0
        */
        public function lcw_score_localizations()
        {
          $plugin_dir = basename( dirname( dirname( __FILE__ ) ) );
          load_plugin_textdomain( 'wss-live-score', false , $plugin_dir . '/lang/' );
        }
        public function lcw_feed()
        {
          add_feed('lcw-feed', array($this,'lcw_feed_content'));
        }
        public function lcw_feed_content( )
        {
            require_once LCW_LIVE_SCORE_ROOT_PATH . '/templates/rss/lcw-feed.php';
            $content         = $this->lcw_get_content('matches?completedLimit=999&inProgressLimit=999&upcomingLimit=999&format=json' );
            $contents        = utf8_encode( $content ); 
            $matches_list    = json_decode( $contents);
            $matches         = $matches_list->matchList->matches;
            lcw_load_feed( $matches );
        }
        /**
         * Get Content from api and return
         *
         * @access public
         * @param void
         * @return $content
         * @since 1.0.0
        */
        public function lcw_get_content( $segment,$is_commentary = 0 ){
          
          if ( function_exists('curl_init')){ 
            
            $curl = curl_init();

            curl_setopt_array($curl, array(
              CURLOPT_URL => $is_commentary == 0 ? 'https://apiv2.cricket.com/cricket/' : 'https://apiv2.cricket.com/cricket/commentary',
              CURLOPT_RETURNTRANSFER => true,
              CURLOPT_ENCODING => '',
              CURLOPT_MAXREDIRS => 10,
              CURLOPT_TIMEOUT => 0,
              CURLOPT_FOLLOWLOCATION => true,
              CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
              CURLOPT_CUSTOMREQUEST => 'POST',
              CURLOPT_POSTFIELDS => $segment ,
            ));

            $content = curl_exec($curl);

            curl_close($curl);
             
          }else{

            $content = 'Please enable curl in order to get cricket data';

          }

          return $content;
      
        }

        
        public function lcw_display_match_tabs( $arr ) {
            $active = '';
            $match_tabs = $arr;
            $tab_list = '<div class="ulcwp-custom-tabs">
                            <ul id="myTab" role="tablist" class="nav nav-tabs">';

            if( has_filter( 'lcw_add_match_tabs' )) {

              $match_tabs = apply_filters('lcw_add_match_tabs', $match_tabs);
            
            }


            foreach( $match_tabs as $match_tab => $match_tab_id ) :
              if( isset($_GET['view']) && $_GET['view'] == strtolower( str_replace(' ', '-', $match_tab))){
                
                $class = 'active';
              
              }else{
                 $class = '';
              }
              $tab_list .= '<li class="nav-item '.$class.'"><a id="upcoming-tab" class="nav-link" href="'.$match_tab_id.'">' . $match_tab . '</a></li>';
              
            endforeach;
            $tab_list .= '</ul></div>';

            return $tab_list;
        }
        public function lcw_add_series_text( $text ){

            return $text;
        }
        public function lcw_add_completed_widget_text( $text )
        {
          return $text;
        }
        public function lcw_add_upcomming_widget_text( $text )
        {
          return $text;
        }
        public function lcw_add_live_widget_text( $text )
        {
          return $text;
        }
        public function lcw_add_upcomming_tab_text( $text ){

            return $text;
        }
        public function lcw_add_completed_tab_text( $text ){

            return $text;
        }
        public function lcw_add_stats_tab_text( $text ){

            return $text;
        }
        public function lcw_add_fixture_text( $text ){

            return $text;
        }
        public function lcw_score_mapping( ){

            if ( !defined( 'WPB_VC_VERSION' ) ) {
              return;
            }
            $countries      = array(
                                    'Australia'     => 1,
                                    'South Africa'  => 6,
                                    'India'         => 3,
                                    'Hong Kong'     => 18,
                                    'Pakistan'      => 5,
                                    'Sri Lanka'     => 7,
                                    'Afghanistan'   => 95,
                                    'Bangladesh'    => 10,
                                    'England'       => 2,
                                    'Windies'       => 8,
                                    'New Zealand'   => 4,
                                  );
            vc_map( 
              array(
                'name' => __('Series', 'wss-live-score'),
                'base' => 'series',
                'description' => __('Shortcode to show series List', 'wss-live-score'), 
                'category' => __('Live Cricket Score', 'wss-live-score'),   
                'icon' => plugins_url( 'images/live-score.png', dirname(__FILE__) ),  
                'params'   => array(
                    array(

                      'type'        => 'dropdown',
                      'heading'     => __('Country'),
                      'param_name'  => 'country_id',
                      'value'       => $countries,
                      'description' => __('Country')
                    )
                  )           
              )
            );
        }
        public function lcw_score_matches_mapping( ){

            if ( !defined( 'WPB_VC_VERSION' ) ) {
              return;
            }

            $content = '';
            $content        = $this->lcw_get_content('series?format=json');
            $contents       = utf8_encode($content); 
            $series         = json_decode($contents);
            $arr            = array();
            $countries      = array(
                                    'Australia'     => 1,
                                    'South Africa'  => 6,
                                    'India'         => 3,
                                    'Hong Kong'     => 18,
                                    'Pakistan'      => 5,
                                    'Sri Lanka'     => 7,
                                    'Afghanistan'   => 95,
                                    'Bangladesh'    => 10,
                                    'England'       => 2,
                                    'Windies'       => 8,
                                    'New Zealand'   => 4,
                                  );
            if( !empty( $series ) ){

              $series_list    = $series->seriesList->series;
              foreach ($series_list as $single_series) {

                $arr[ $single_series->name ] = $single_series->id;

              }
              $arr[ 'World Cup 2019' ] = 2181;
              // Map the block with vc_map()
              vc_map( 

                array(

                  'name' => __('Series Matches List', 'wss-live-score'),
                  'base' => 'series-matches',
                  'description' => __('Show specific series matches ', 'wss-live-score'), 
                  'category' => __('Live Cricket Score', 'wss-live-score'),   
                  'icon' => plugins_url( 'images/cricket-icon.png', dirname(__FILE__) ), 
                  'params'   => array(
                    array(

                      'type'        => 'dropdown',
                      'heading'     => __('Series id'),
                      'param_name'  => 'series_id',
                      'value'       => $arr,
                      'description' => __('Series id')
                    )
                  )           

                )
              );
              vc_map( 

                array(

                  'name' => __('Country Wise Matches List', 'wss-live-score'),
                  'base' => 'country-matches',
                  'description' => __('Country Wise Matches List ', 'wss-live-score'), 
                  'category' => __('Live Cricket Score', 'wss-live-score'),   
                  'icon' => plugins_url( 'images/cricket-icon.png', dirname(__FILE__) ), 
                  'params'   => array(
                    array(

                      'type'        => 'dropdown',
                      'heading'     => __('Country'),
                      'param_name'  => 'country_id',
                      'value'       => $countries,
                      'description' => __('Return Matches of the above country')
                    ),
                    
                  )           

                )
              );
              vc_map( 

                array(

                  'name' => __('Minimal Series Matches', 'wss-live-score'),
                  'base' => 'simple-matches',
                  'description' => __('Show specific series matches with specific Number of matches ', 'wss-live-score'), 
                  'category' => __('Live Cricket Score', 'wss-live-score'),   
                  'icon' => plugins_url( 'images/cricket-icon.png', dirname(__FILE__) ), 
                  'params'   => array(
                    array(

                      'type'        => 'dropdown',
                      'heading'     => __('Series id'),
                      'param_name'  => 'series_id',
                      'value'       => $arr,
                      'description' => __('Series id')
                    ),
                    array(

                      'type'        => 'textfield',
                      'heading'     => __('Upcoming Matches'),
                      'param_name'  => 'upcoming',
                      'description' => __('Upcoming Matches')
                    ),
                    array(

                      'type'        => 'textfield',
                      'heading'     => __('Live Matches'),
                      'param_name'  => 'live',
                      'description' => __('Live Matches')
                    ),
                    array(

                      'type'        => 'textfield',
                      'heading'     => __('Completed Matches'),
                      'param_name'  => 'completed',
                      'description' => __('Completed Matches')
                    ),
                    array(

                      'type'        => 'colorpicker',
                      'heading'     => __('Series Color'),
                      'param_name'  => 'color',
                      'description' => __('Series Color')
                    ),
                  )           

                )
              );
            }
        }
        public function lcw_add_css_code(){

            if( get_option('base_color') ){
              echo "<style>
              .ulcwp-custom-tabs .nav-tabs .nav-item.active a,.lcw-commentry-box-header, .lcw-over-box,.lcw-commentry-box-header,.lcw-series .lcw-series-tiles,.lcw-endof-over,.lcw-batsmen .lcw-thead .lcw-tr,.player-profile-card .player-badge,.player-match-wrapper{

                background-color: ".get_option('base_color')." !important;
              }
              .lcw-livescore-outer .nav > li > a:hover, .lcw-livescore-outer .nav > li > a:focus{
                 background-color: ".get_option('base_color')." !important;
              }
              .lcw-tabs a.active,.lcw-tabs a.hover, .lcw-livescore-outer .nav-tabs .nav-link.active,.lcw-livescore-outer .nav-tabs>li.active>a{
                
                border-bottom: 1px solid ".get_option('base_color').";
              }
              .nav-tabs li a.nav-link.active{
                color: ".get_option('base_color')." !important;
                border-bottom: 1px solid ".get_option('base_color').";
              }
              {
                background: ".get_option('base_color')." !important;
              }
              .book-now-c a,.overview{
                background-color: ".get_option('base_color')." !important;
              }
             
              #accordion .panel-title a:before, #accordion .panel-title a.collapsed:before,.lcw-match-slider-inner ,.player-profile-card .player-name h4{
                  color: ".get_option('base_color')." !important;
              }
              .series-inner {
                  border: 1px solid ".get_option('base_color')." !important;
              }
              @media screen and (max-width: 767px){
              .lcw-livescore-outer .nav-tabs .nav-link.active:after {
                  background: ".get_option('base_color')." !important;
                }
              }
              </style>";
            }
            
        }
        public function lcw_add_js_code(  ){
          
          
        }
        public function lcw_score_series_shortcode( $atts ){
          
          if( !$this->check_license_validation() ){
              
                   return 'Sorry! Your license is invalid.Please <a href="http://ulcwp.com/pricing-plans/">purchase Plugin copy</a> and get valid license!';
          }

          extract(shortcode_atts(
            array(

              'col'        => '',
              'country_id' => '',
              'tab'        => 'live'
            ), $atts));
          
          if( get_query_var( 'tab' ) ){

            $series_status = get_query_var( 'tab' );

          }else{

            $series_status = $tab;
          }
          $series_content     = '';
          
          $series_content     = $this->lcw_get_content('{"query":"query seriesPriority($tab: String, $filter: String, $country: String, $format: String, $page: Int) {\\n  seriesPriority(tab: $tab, filter: $filter, country: $country, format: $format, page: $page) {\\n    tourName\\n    seriesSearchNameForES\\n    tourID\\n    league\\n    seriesStartDate\\n    seriesEndDate\\n    T20count\\n    matchLevel\\n    Odicount\\n    Testcount\\n  }\\n}\\n","variables":{"tab":"'.$series_status.'","filter":"","country":"","format":"","page":0}}');
          
          
          $contents           = utf8_encode($series_content); 
          $series             = json_decode($contents);
          $series_list        = '';

          //print_r($series);
          if(!empty( $series ) ){

            $series_list    = $series->data->seriesPriority;
            $series_style = 3;
            
            require_once LCW_LIVE_SCORE_ROOT_PATH . '/templates/series-list-'.$series_style.'.php';
            $series_list = lcw_load_series_list_3( $series_list,$series_style );
             
          }
          
          return $series_list;
            
        }
        
        public function lcw_score_country_matches_shortcode( $atts )
        {
          
          ob_start();
          // extract(shortcode_atts(
          //   array(

          //     'country_id'       => -1,
          //     'series_id'       => -1,

          //   ), $atts));
          
          // require_once LCW_LIVE_SCORE_ROOT_PATH . '/templates/country-matches.php';
          // $content = lcw_load_country_matches( $matches );
            
          return false;
        }
        
        public function lcw_score_series_matches_shortcode( $atts )
        {
          global $post;
          $post_slug=$post->post_name;
          if( !$this->check_license_validation() ){
              
              return 'Sorry! Your license is invalid.Please <a href="http://ulcwp.com/pricing-plans/">purchase Plugin copy</a> and get valid license!';
          }

          ob_start();
          extract(shortcode_atts(
            array(

              'series_id'       => -1,


            ), $atts));

          if( get_query_var( 'series' ) ){

            $series_id = get_query_var( 'series' );

          }else{

            $series_id = $series_id;
          }
          
          if( get_query_var( 'series-name' ) ){

            $series_name = get_query_var( 'series-name' );

          }else{

              $series_name = $post_slug;
          }

          if(get_query_var('type')){

            $series_status = get_query_var('type');

          }else{

            $series_status = "matches";
          }
          
          $active_tab_completed = '';
          $active_tab_standings = '';
          $active_tab_stats = '';

          $active_tab_current   = '';

          if( $series_status == 'standings' ){

            $active_tab_standings = 'active';

          }elseif( $series_status == 'stats' ){

            $active_tab_stats = 'active';

          }else{

            $active_tab_current = 'active';
          }
          //$series_name = preg_replace("/[^a-zA-Z]/", "-", $series_name);
          $match_text           = apply_filters('lcw_fixture_text', 'Fixtures'); 
          $stats_tab_text       = apply_filters('lcw_stats_tab_text', 'STATS'); 
          $upcomming_tab_text   = apply_filters('lcw_upcomming_tab_text', 'Matches');
          $standing_tab_text    = apply_filters('lcw_standing_tab_text', 'Standings');
          
          
          ?>          
            <div class="ulcwp-custom-tabs"> 
              <ul id="myTab" role="tablist" class="nav nav-tabs">
                
                <li class="nav-item <?php echo $active_tab_current ?>">
                  <a id="upcoming-tab" href="<?php echo home_url($series_name.'/'.$series_id.'/matches/') ?>" class="nav-link"><?php echo $upcomming_tab_text; ?></a>
                </li>
                <li class="nav-item <?php echo $active_tab_stats ?>">
                  <a id="live-tab" href="<?php echo home_url($series_name.'/'.$series_id.'/stats/') ?>" class="nav-link"><?php echo $stats_tab_text; ?></a>
                </li>
                <li class="nav-item <?php echo $active_tab_standings ?>">
                  <a id="result-tab" href="<?php echo home_url($series_name.'/'.$series_id.'/standings') ?>" class="nav-link"><?php echo $standing_tab_text; ?></a>
                </li>
              </ul>
            </div>
          <?php
          $content = ob_get_clean();
          if( $series_status == 'standings' ){
             
              require_once LCW_LIVE_SCORE_ROOT_PATH . '/templates/standings.php';
              $content .= lcw_load_standings( $series_id );

            }elseif( $series_status == 'stats' ){
              
              require_once LCW_LIVE_SCORE_ROOT_PATH . '/templates/series-stats.php';
              $content .= lcw_load_stats( $series_id );

            }else{

              $match_content        = $this->lcw_get_content('{"query":"query matcheslist($seriesID: String!){\\n    matcheslist(seriesID: $seriesID) {\\n      matchName\\n      isPoints\\n      isStatistics\\n      homeTeamShortName\\n      awayTeamShortName\\n      matchResult\\n      venue\\n      matchNumber\\n      matchdate\\n      matchID\\n      matchStatus\\n      startDate\\n      matchType\\n      statusMessage\\n      playing11Status\\n      probable11Status\\n      playerOfTheMatch\\n      playerID\\n      firstInningsTeamID\\n      secondInningsTeamID\\n      thirdInningsTeamID\\n      fourthInningsTeamID\\n    winningTeamID\\n  currentinningsNo\\n      currentInningteamID\\n      currentInningsTeamName\\n      seriesName\\n      seriesID\\n      toss\\n      teamsWinProbability {\\n        homeTeamShortName\\n        homeTeamPercentage\\n        awayTeamShortName\\n        awayTeamPercentage\\n        tiePercentage\\n      }\\n      matchScore{\\n        teamShortName\\n        teamID\\n        teamFullName\\n        teamScore{\\n          inning\\n          inningNumber\\n          battingTeam\\n          runsScored\\n          wickets\\n          overs\\n          runRate\\n          battingSide\\n          teamID\\n          battingTeamShortName\\n          declared\\n          folowOn\\n        }\\n\\n      }\\n\\n    }\\n}\\n","variables":{"seriesID":"'.$series_id.'"}}');
              $contents       = utf8_encode($match_content); 
              $matches_list   = json_decode($contents);
              
              $matches        = $matches_list->data->matcheslist;
              require_once LCW_LIVE_SCORE_ROOT_PATH . '/templates/upcomming-matches.php';
              $content .= lcw_load_upcomming_matches( $matches );
            }

            return $content;
        }
        
        public function series_standings( )
        {
          ob_start();
          /*extract(shortcode_atts(
            array(

              'series_id'       => -1,

            ), $atts));*/
            $series_id = $_POST['series_id'];
            $standings_content    = $this->lcw_get_content('series/standings/'.$series_id.'?format=json' );
            $standings_contents   = utf8_encode( $standings_content ); 
            $standings_list       = json_decode( $standings_contents);
            require_once LCW_LIVE_SCORE_ROOT_PATH . '/templates/minimal-standings.php';
            $content = lcw_load_minimal_standings( $standings_list );
            echo $content;
            die();
        }
        
        public function lcw_country_matches_shortcode( $atts ){
          ob_start();
              extract(shortcode_atts(
                array(

                  'series_id'       => -1,
                  'upcoming'        => 1,
                  'live'            => 1,
                  'completed'       => 1,
                  'color'           => '#000',
                  'country_id'      => -1,
                ), $atts));

              $home_content        = $this->lcw_get_content('matches/'.$series_id.'?inProgressLimit='.$live.'&completedLimit='.$completed.'&upcomingLimit='.$upcoming.'&TeamId='.$country_id);
              $home_contents       = utf8_encode( $home_content ); 
              $home_matches_list   = json_decode( $home_contents);
                
              $matches        = $home_matches_list->matchList->matches;
              require_once LCW_LIVE_SCORE_ROOT_PATH . '/templates/home-matches.php';
              $content        = lcw_load_home_matches( $matches );
              return $content;
        }
        
        public function lcw_match_detail_shortcode( $atts ){
          //global $match_detail_list;
          extract(shortcode_atts(
            array(
              
              'match_id'        => -1,
              'status'          =>  '',
              'show_sections'   => 'show_score_card,show_partnerships,show_graphs,show_teams,show_commentary',
            ), $atts));
         
          if( get_query_var( 'match-id' ) ){

            $match_id = get_query_var( 'match-id' );

          }else{

            $match_id = $match_id;
          }
          if( get_query_var( 'status' ) ){

            $status = get_query_var( 'status' );

          }else{

            $status = $status;
          }
           
          
          require_once LCW_LIVE_SCORE_ROOT_PATH . '/templates/match-detail.php';
          $content = lcw_load_match_detail( $this,$status,$match_id,explode( ',', $show_sections )  );
          
          return $content;
        }
        public function lcw_change_page_title($title){

            global $post;
            if( get_query_var( 'series' ) ){

                    $series_id = get_query_var( 'series' );

            }else{

                $series_id = '';
            }
            if( get_query_var( 'match-id' ) ){

                $match_id = get_query_var( 'match-id' );

            }else{

                $match_id = '';
            }
            if( get_query_var( 'player' ) ){


            }
            if( get_query_var( 'team-name' ) ){

                  $team_name = str_replace('-',' ', get_query_var( 'team-name' ));

            }
          if( in_the_loop() && !is_archive() ){
            
            if( is_page('match-center' ) ){
                
                $newtitle = str_replace('-',' ',get_query_var('match-name'));

                       
                    
                  return strtoupper($newtitle);

                
              }
              // }elseif( is_page( 'player-stats' ) ){
                  
                //   $player_id = get_query_var( 'player' );

                
                
                // }
              else{

                return $title;
              }
            
          }else{
              
              return $title;
          }
          
        }
        public function lcw_change_document_title( $title  ){

              
              $newtitle       = '';
              if( get_query_var( 'series' ) ){

                  $series_id = get_query_var( 'series' );

              }else{

                $series_id = '';
              }
              if( get_query_var( 'match-id' ) ){

                $match_id = get_query_var( 'match-id' );

              }else{

                $match_id = '';
            }
            if( get_query_var( 'player' ) ){


            }
            if( get_query_var( 'team-name' ) ){

                  $team_name = str_replace('-',' ', get_query_var( 'team-name' ));

              }
            if( ! empty( $title ) &&  is_page('match-center' ) ){

                    $match_detail_content    =  $this->lcw_get_content('{"query":"query miniScoreCard($matchID: String!) {\\n  miniScoreCard(matchID: $matchID) {\\n    isDisplayDugout\\n    batting {\\n      matchID\\n      playerFeedID\\n      playerName\\n      sixes\\n      fours\\n      runs\\n      playerOnStrike\\n      playerDismissalInfo\\n    }\\n    bowling {\\n      matchID\\n      playerFeedID\\n      playerName\\n      playerTeam\\n      wickets\\n      maiden\\n      RunsConceeded\\n      overs\\n      economy\\n    }\\n    partnership\\n    oversRemaining\\n    reviewDetails {\\n      teamName\\n      review\\n    }\\n    runRate\\n    rRunRate\\n    data {\\n    winningTeamID\\n   currentinningsNo\\n      currentInningteamID\\n      currentInningsTeamName\\n      seriesName\\n      seriesID\\n      homeTeamName\\n      awayTeamName\\n      toss\\n      startEndDate\\n      matchStatus\\n      matchID\\n      matchType\\n      statusMessage\\n      matchNumber\\n      venue\\n      matchResult\\n      startDate\\n      playerID\\n      playerOfTheMatch\\n      playerofTheMatchTeamShortName\\n      firstInningsTeamID\\n      secondInningsTeamID\\n      thirdInningsTeamID\\n      fourthInningsTeamID\\n      isCricklyticsAvailable\\n      isFantasyAvailable\\n      isLiveCriclyticsAvailable\\n      isAbandoned\\n      playing11Status\\n      probable11Status\\n      currentDay\\n      currentSession\\n      teamsWinProbability {\\n        homeTeamShortName\\n        homeTeamPercentage\\n        awayTeamShortName\\n        awayTeamPercentage\\n        tiePercentage\\n      }\\n      matchScore {\\n        teamShortName\\n        teamID\\n        teamFullName\\n        teamScore {\\n          inning\\n          inningNumber\\n          battingTeam\\n          runsScored\\n          wickets\\n          overs\\n          runRate\\n          battingSide\\n          teamID\\n          battingTeamShortName\\n          declared\\n          folowOn\\n        }\\n      }\\n    }\\n  }\\n}\\n","variables":{"matchID":"'.$match_id.'"}}');
                      $match_detail_contents   =  utf8_encode( $match_detail_content ); 
                      $match                   =  json_decode($match_detail_contents);
                      
                      $newtitle = $match->data->miniScoreCard->data[0]->matchScore[0]->teamFullName.' vs '. $match->data->miniScoreCard->data[0]->matchScore[1]->teamFullName.', '.$match->data->miniScoreCard->data[0]->seriesName.' | '.$title;

                       
                    
                    return $newtitle;

                }elseif( is_page( 'player-stats' ) ){
                  
                  $player_id = get_query_var( 'player' );

                  $player_stats_content    =  $this->lcw_get_content('{"query":"query getPlayersProfileV2($playerID: String!) {\\n  getPlayersProfileV2(playerID: $playerID) {\\n    name\\n    playerID\\n    \\n  }\\n}\\n","variables":{"playerID":"'.$player_id.'"}}');
                  //$player_stats_contents   =  utf8_encode( $player_stats_content ); 
                  $player_stats_list       =  json_decode( $player_stats_content);
                  $newtitle = $player_stats_list->data->getPlayersProfileV2->name.' profile and biography, stats, records, averages, photos and videos |'.$title;
                  return $newtitle;
                }
                elseif( is_page('matches' ) ){
                  
                  $series = get_query_var( 'series' );
                  $match_content        = $this->lcw_get_content('{"query":"query matcheslist($seriesID: String!){\\n    matcheslist(seriesID: $seriesID) {\\n      matchName\\n      isPoints\\n      isStatistics\\n      homeTeamShortName\\n      awayTeamShortName\\n      matchResult\\n      venue\\n      matchNumber\\n      matchdate\\n      matchID\\n      matchStatus\\n      startDate\\n      matchType\\n      statusMessage\\n      playing11Status\\n      probable11Status\\n      playerOfTheMatch\\n      playerID\\n      firstInningsTeamID\\n      secondInningsTeamID\\n      thirdInningsTeamID\\n      fourthInningsTeamID\\n    winningTeamID\\n  currentinningsNo\\n      currentInningteamID\\n      currentInningsTeamName\\n      seriesName\\n      seriesID\\n      toss\\n      teamsWinProbability {\\n        homeTeamShortName\\n        homeTeamPercentage\\n        awayTeamShortName\\n        awayTeamPercentage\\n        tiePercentage\\n      }\\n      matchScore{\\n        teamShortName\\n        teamID\\n        teamFullName\\n        teamScore{\\n          inning\\n          inningNumber\\n          battingTeam\\n          runsScored\\n          wickets\\n          overs\\n          runRate\\n          battingSide\\n          teamID\\n          battingTeamShortName\\n          declared\\n          folowOn\\n        }\\n\\n      }\\n\\n    }\\n}\\n","variables":{"seriesID":"'.$series.'"}}');
                  $contents       = utf8_encode($match_content); 
                  $matches_list   = json_decode($contents);
              
                  $matches        = $matches_list->data->matcheslist;
                  $series_name    = $matches[0]->seriesName;
                  $newtitle = $series_name.' Live Score, Points Table, Teams , News , stats and matches | '.get_bloginfo( 'name');;
                   return $newtitle;
                }
                elseif( is_page('team' ) ){
                  
          
                   
                  $newtitle = ucfirst($team_name).' Live Score, Matches , Schedule | '.get_bloginfo( 'name');;
                   return $newtitle;
                }else{

                return $title;
              }
              
          }
          public function lcw_change_document_title_parts( $title_parts )
          {
            
            
              if( get_query_var( 'series' ) ){

                  $series_id = get_query_var( 'series' );

              }else{

                $series_id = '';
              }
              if( get_query_var( 'match-id' ) ){

                $match_id = get_query_var( 'match-id' );

              }else{

                $match_id = '';
              }
                           
              if( is_page('match-center' ) ){

                    $match_detail_content    =  $this->lcw_get_content('{"query":"query miniScoreCard($matchID: String!) {\\n  miniScoreCard(matchID: $matchID) {\\n    isDisplayDugout\\n    batting {\\n      matchID\\n      playerFeedID\\n      playerName\\n      sixes\\n      fours\\n      runs\\n      playerOnStrike\\n      playerDismissalInfo\\n    }\\n    bowling {\\n      matchID\\n      playerFeedID\\n      playerName\\n      playerTeam\\n      wickets\\n      maiden\\n      RunsConceeded\\n      overs\\n      economy\\n    }\\n    partnership\\n    oversRemaining\\n    reviewDetails {\\n      teamName\\n      review\\n    }\\n    runRate\\n    rRunRate\\n    data {\\n    winningTeamID\\n   currentinningsNo\\n      currentInningteamID\\n      currentInningsTeamName\\n      seriesName\\n      seriesID\\n      homeTeamName\\n      awayTeamName\\n      toss\\n      startEndDate\\n      matchStatus\\n      matchID\\n      matchType\\n      statusMessage\\n      matchNumber\\n      venue\\n      matchResult\\n      startDate\\n      playerID\\n      playerOfTheMatch\\n      playerofTheMatchTeamShortName\\n      firstInningsTeamID\\n      secondInningsTeamID\\n      thirdInningsTeamID\\n      fourthInningsTeamID\\n      isCricklyticsAvailable\\n      isFantasyAvailable\\n      isLiveCriclyticsAvailable\\n      isAbandoned\\n      playing11Status\\n      probable11Status\\n      currentDay\\n      currentSession\\n      teamsWinProbability {\\n        homeTeamShortName\\n        homeTeamPercentage\\n        awayTeamShortName\\n        awayTeamPercentage\\n        tiePercentage\\n      }\\n      matchScore {\\n        teamShortName\\n        teamID\\n        teamFullName\\n        teamScore {\\n          inning\\n          inningNumber\\n          battingTeam\\n          runsScored\\n          wickets\\n          overs\\n          runRate\\n          battingSide\\n          teamID\\n          battingTeamShortName\\n          declared\\n          folowOn\\n        }\\n      }\\n    }\\n  }\\n}\\n","variables":{"matchID":"'.$match_id.'"}}');
                      $match_detail_contents   =  utf8_encode( $match_detail_content ); 
                      $match                   =  json_decode($match_detail_contents);

                      $title_parts['title'] = $match->data->miniScoreCard->data[0]->matchScore[0]->teamFullName.' vs '. $match->data->miniScoreCard->data[0]->matchScore[1]->teamFullName.', '.$match->data->miniScoreCard->data[0]->seriesName;
                       
                }elseif(is_page('player-stats')){

                  $player_id = get_query_var( 'player' );
                  $player_stats_content    =  $this->lcw_get_content('{"query":"query getPlayersProfileV2($playerID: String!) {\\n  getPlayersProfileV2(playerID: $playerID) {\\n    name\\n    playerID\\n    \\n  }\\n}\\n","variables":{"playerID":"'.$player_id.'"}}');
                  $player_stats_contents   =  utf8_encode( $player_stats_content ); 
                  $player_stats_list       =  json_decode( $player_stats_contents);
                  $title_parts['title'] = $player_stats_list->data->getPlayersProfileV2->name.' profile and biography, stats, records, averages, photos and videos |'.get_bloginfo( 'name');

                }elseif( is_page('matches' ) ){

                  $series                    = get_query_var( 'series' );

                  $match_content        = $this->lcw_get_content('{"query":"query matcheslist($seriesID: String!){\\n    matcheslist(seriesID: $seriesID) {\\n      matchName\\n      isPoints\\n      isStatistics\\n      homeTeamShortName\\n      awayTeamShortName\\n      matchResult\\n      venue\\n      matchNumber\\n      matchdate\\n      matchID\\n      matchStatus\\n      startDate\\n      matchType\\n      statusMessage\\n      playing11Status\\n      probable11Status\\n      playerOfTheMatch\\n      playerID\\n      firstInningsTeamID\\n      secondInningsTeamID\\n      thirdInningsTeamID\\n      fourthInningsTeamID\\n    winningTeamID\\n  currentinningsNo\\n      currentInningteamID\\n      currentInningsTeamName\\n      seriesName\\n      seriesID\\n      toss\\n      teamsWinProbability {\\n        homeTeamShortName\\n        homeTeamPercentage\\n        awayTeamShortName\\n        awayTeamPercentage\\n        tiePercentage\\n      }\\n      matchScore{\\n        teamShortName\\n        teamID\\n        teamFullName\\n        teamScore{\\n          inning\\n          inningNumber\\n          battingTeam\\n          runsScored\\n          wickets\\n          overs\\n          runRate\\n          battingSide\\n          teamID\\n          battingTeamShortName\\n          declared\\n          folowOn\\n        }\\n\\n      }\\n\\n    }\\n}\\n","variables":{"seriesID":"'.$series.'"}}');
                  $contents       = utf8_encode($match_content); 
                  $matches_list   = json_decode($contents);
              
                  $matches        = $matches_list->data->matcheslist;
                  $series_name    = $matches[0]->seriesName;
                  $title_parts['title'] = $series_name.' Live Score, Points Table, Teams , News , stats and matches |'.get_bloginfo( 'name');
                }
                
                return $title_parts;
          }
        public function lcw_player_stats_shortcode( $atts ){
          ob_start();
          
          extract(shortcode_atts(
            array(

              'player_id'       => -1,

            ), $atts));          
          
          if( get_query_var( 'player' ) ){

            $player_id = get_query_var( 'player' );

          }else{

            $player_id = $player_id;
          }
          $player_stats_content    =  $this->lcw_get_content('{"query":"query getPlayersProfileV2($playerID: String!) {\\n  getPlayersProfileV2(playerID: $playerID) {\\n    name\\n    playerID\\n    birthPlace\\n    dob\\n    description\\n    battingStyle\\n    bowlingStyle\\n    headShotImage\\n  teamID\\n  actionShotImage\\n    similarplayers {\\n      playerID\\n      headShotImage\\n      playerName\\n      similarity\\n    }\\n    international {\\n      Test {\\n        basicdetails {\\n          matches\\n          innings\\n        }\\n        debutMatch {\\n          matchID\\n          date\\n          against\\n          againstID\\n          format\\n        }\\n        lastMatch {\\n          matchID\\n          date\\n          against\\n          againstID\\n          format\\n        }\\n        battingRecord {\\n          notOuts\\n          runs\\n          ballsFaced\\n          hundreds\\n          fifties\\n          fours\\n          sixes\\n          average\\n          strikeRate\\n          innings\\n          hundredsfifties\\n          foursix\\n          format\\n          matches\\n        }\\n        bowlingRecord {\\n          overs\\n          wickets\\n          ballsBowled\\n          average\\n          strikeRate\\n          economyRate\\n          fiveWicketHauls\\n          innings\\n          bestBowling\\n          fivetenWicketHauls\\n        }\\n      }\\n      Odi {\\n        basicdetails {\\n          matches\\n          innings\\n        }\\n        debutMatch {\\n          matchID\\n          date\\n          against\\n          againstID\\n          format\\n        }\\n        lastMatch {\\n          matchID\\n          date\\n          against\\n          againstID\\n          format\\n        }\\n        battingRecord {\\n          notOuts\\n          runs\\n          ballsFaced\\n          hundreds\\n          fifties\\n          fours\\n          sixes\\n          average\\n          strikeRate\\n          innings\\n          hundredsfifties\\n          foursix\\n          format\\n          matches\\n        }\\n        bowlingRecord {\\n          overs\\n          wickets\\n          ballsBowled\\n          average\\n          strikeRate\\n          economyRate\\n          fiveWicketHauls\\n          innings\\n          bestBowling\\n          fivetenWicketHauls\\n        }\\n      }\\n      T20 {\\n        basicdetails {\\n          matches\\n          innings\\n        }\\n        debutMatch {\\n          matchID\\n          date\\n          against\\n          againstID\\n          format\\n        }\\n        lastMatch {\\n          matchID\\n          date\\n          against\\n          againstID\\n          format\\n        }\\n        battingRecord {\\n          notOuts\\n          runs\\n          ballsFaced\\n          hundreds\\n          fifties\\n          fours\\n          sixes\\n          average\\n          strikeRate\\n          innings\\n          hundredsfifties\\n          foursix\\n          format\\n          matches\\n        }\\n        bowlingRecord {\\n          overs\\n          wickets\\n          ballsBowled\\n          average\\n          strikeRate\\n          economyRate\\n          fiveWicketHauls\\n          innings\\n          bestBowling\\n          fivetenWicketHauls\\n        }\\n      }\\n    }\\n    Ipl {\\n      basicdetails {\\n        matches\\n        innings\\n      }\\n      debutMatch {\\n        matchID\\n        date\\n        against\\n        againstID\\n        format\\n      }\\n      lastMatch {\\n        matchID\\n        date\\n        against\\n        againstID\\n        format\\n      }\\n      battingRecord {\\n        notOuts\\n        runs\\n        ballsFaced\\n        hundreds\\n        fifties\\n        fours\\n        sixes\\n        average\\n        strikeRate\\n        innings\\n        hundredsfifties\\n        foursix\\n        format\\n        matches\\n      }\\n      bowlingRecord {\\n        overs\\n        wickets\\n        ballsBowled\\n        average\\n        strikeRate\\n        economyRate\\n        fiveWicketHauls\\n        innings\\n        bestBowling\\n        fivetenWicketHauls\\n      }\\n    }\\n    role\\n    fullName\\n    playerIPLTeam\\n    playerIPLBid\\n    battingStats {\\n      notOuts\\n      runs\\n      ballsFaced\\n      hundreds\\n      fifties\\n      fours\\n      sixes\\n      average\\n      recForm {\\n        a\\n        b\\n      }\\n      color\\n      strikeRate\\n      innings\\n      hundredsfifties\\n      foursix\\n      format\\n      matches\\n    }\\n    bowlingStats {\\n      format\\n      matches\\n      overs\\n      wickets\\n      ballsBowled\\n      average\\n      recForm {\\n        a\\n        b\\n      }\\n      color\\n      strikeRate\\n      economyRate\\n      fiveWicketHauls\\n      innings\\n      bestBowling\\n      fivetenWicketHauls\\n    }\\n    fieldingStats {\\n      format\\n      catches\\n      stupms\\n      runOuts\\n    }\\n  }\\n}\\n","variables":{"playerID":"'.$player_id.'"}}');
          $player_stats_contents   =  utf8_encode( $player_stats_content ); 
          $player_stats_list       =  json_decode( $player_stats_contents);

          if( empty($player_stats_list ) ){

            return false;
          }
          require_once LCW_LIVE_SCORE_ROOT_PATH . '/templates/player-stats.php';

          $content = lcw_load_player_stats( $this,$player_stats_list);

          return $content;
        }
        public function lcw_score_front_styles( ){
          if(!get_option('disable_bootstrap')){
            
            $this->enqueue_style( 'wss-live-score-bootstrap-style',plugins_url( 'lib/bootstrap3/css/bootstrap.css', dirname(__FILE__) ),false, LCW_LIVE_SCORE_VERSION);
          }
          $this->enqueue_style( 'wss-live-score-slick-style',plugins_url( 'css/slick.css', dirname(__FILE__) ),false, LCW_LIVE_SCORE_VERSION);

          $this->enqueue_style( 'wss-live-score-fontawesome-style',plugins_url( 'lib/fa/all.min.css', dirname(__FILE__) ),false, LCW_LIVE_SCORE_VERSION);
          $this->enqueue_style( 'wss-live-score-main-style', plugins_url( 'css/style.css', dirname(__FILE__) ),false, LCW_LIVE_SCORE_VERSION);
          
          $this->enqueue_style( 'wss-live-score-media-query-style', plugins_url( 'css/media-query.css', dirname(__FILE__) ),false, LCW_LIVE_SCORE_VERSION);
          
        }
      /**
       * Localize script to register ajax url
       *
       * @access public
       * @param void
       * @return void
       * @since 1.0.0
      */
      public function lcw_score_front_reg_scripts( ){
        $ajax_array = array(

          'ajaxurl' => admin_url('admin-ajax.php'),
          'image_path' => plugins_url('images', dirname(__FILE__))
        );
        $this->register_script ( 'lcw-score-front-js', plugins_url('js/script.js', dirname(__FILE__)), false, LCW_LIVE_SCORE_VERSION );

        wp_localize_script ( 'lcw-score-front-js','ajax_params', $ajax_array);
      }
      public function lcw_score_front_scripts( ){

        wp_enqueue_script('jquery');
      
        $this->enqueue_script ( 'lcw-highchart-js', 'https://code.highcharts.com/highcharts.js', false, LCW_LIVE_SCORE_VERSION,false);
        if(!get_option('disable_bootstrap')){
          
          $this->enqueue_script('lcw-bootstrap-js',plugins_url( 'lib/bootstrap3/js/bootstrap.min.js', dirname(__FILE__)), false, LCW_LIVE_SCORE_VERSION);
        }
        
        $this->enqueue_script('lcw-slick-js',plugins_url( 'js/slick.min.js', dirname(__FILE__)), false, LCW_LIVE_SCORE_VERSION);
        
        //$this->enqueue_script('lcw-infinte-js',plugins_url( 'js/infinite.js', dirname(__FILE__)), false, LCW_LIVE_SCORE_VERSION);
        $this->add_existed_script ( 'lcw-score-front-js' );
      }
      
      public function lcw_settings_tabs( $current = 'settings' ) {

        $tabs = array(  

          'settings'      =>  'Settings', 
          'shortcodes'    =>  'Shortcodes Generator',
          'license'       =>  'Activate License',

        );

        echo '<div id="icon-themes" class="icon32"></div>';
        echo '<div class="left-area">';
        echo '<h2 class="nav-tab-wrapper ulcwp-tabs">';

        foreach( $tabs as $tab => $name ){

          $class = ( $tab == $current ) ? ' nav-tab-active' : '';
          echo "<a class='nav-tab$class' href='?page=lcw-score-settings&tab=$tab'>$name</a>";
        }

        echo '</h2>';
      }
      /**
       * Add Scripts in admin Side
       *
       * @access public
       * @param void
       * @return void
       * @since 1.0.0
      */
      public function lcw_score_admin_scripts(  ) {
        $this->enqueue_script ( 'lcw-select2-js', 'https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.5/js/select2.min.js', false, LCW_LIVE_SCORE_VERSION);
       
        $this->enqueue_script ( 'lcw-score-admin-js', plugins_url('js/lcw-score-admin.js', dirname(__FILE__)), array( 'wp-color-picker' ), LCW_LIVE_SCORE_VERSION);
        
      }
      /**
       * Add stylesheets in admin Side
       *
       * @access public
       * @param void
       * @return void
       * @since 1.0.0
      */
      public function lcw_score_admin_styles( ) {
        wp_enqueue_style( 'wp-color-picker' );
        $this->enqueue_style ( 'lcw-select2-css', 'https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.5/css/select2.min.css', false, LCW_LIVE_SCORE_VERSION);
      }
      
      /**
       * Add rewrite tags and rules
       */
      public function lcw_rewrite_rules() {
        add_rewrite_rule(
            '([^/]*)/([0-9]{1,})/([^/]*)',
            'index.php?pagename=matches&series-name=$matches[1]&series=$matches[2]&type=$matches[3]',
            'top'
        );
        add_rewrite_rule(
            'live-score/([^/]*)/([0-9]{1,})/([^/]*)',
            'index.php?pagename=match-center&match-name=$matches[1]&match-id=$matches[2]&status=$matches[3]',
            'top'
        );
        add_rewrite_rule(
            'series/([^/]*)',
            'index.php?pagename=series&tab=$matches[1]',
            'top'
        );
        
        add_rewrite_rule(
            'live-cricket-scores/([^/]*)',
            'index.php?pagename=live-cricket-scores&status=$matches[1]',
            'top'
        );
        
        add_rewrite_rule(
            'stats/([^/]*)/([0-9]{1,})/([^/]*)',
            'index.php?pagename=player-stats&player-name=$matches[1]&player=$matches[2]&type=$matches[3]',
            'top'
        );
        add_rewrite_rule(
            'team/([^/]*)/([0-9]{1,})',
            'index.php?pagename=team&team-name=$matches[1]&team-id=$matches[2]',
            'top'
        );
        add_rewrite_rule(
            'team-rank/([^/]*)',
            'index.php?pagename=team-rank&type=$matches[1]',
            'top'
        );
        add_rewrite_tag( '%player%', '([^&]+)' );  
        add_rewrite_tag( '%series%', '([^&]+)' );
        add_rewrite_tag( '%tab%'   , '([^/]*)' );
        add_rewrite_tag( '%match%', '([^&]+)' );
        add_rewrite_tag( '%status%', '([^&]+)' );
        add_rewrite_tag( '%type%' , '([^/]*)' );
        add_rewrite_tag( '%match-name%', '([^/]*)' );
        add_rewrite_tag( '%match-id%', '([^/]*)' );
        add_rewrite_tag( '%match%', '([^/]*)' );
        add_rewrite_tag( '%teams-name%', '([^/]*)' );
        add_rewrite_tag( '%team-name%', '([^/]*)' );
        add_rewrite_tag( '%section%', '([^/]*)' );
        add_rewrite_tag( '%team-id%', '([^&]+)' );
        add_rewrite_tag( '%player-name%', '([^/]*)' );
        add_rewrite_tag( '%series-name%', '([^/]*)' );
        add_rewrite_tag( '%series-type%', '([^/]*)' );
        add_rewrite_tag( '%series-ids%', '([^/]*)' );

      }
      
      /**
       * Save options after activate plugin
       *
       * @access public
       * @param void
       * @return void
       * @since 1.0.0
      */
      public static function lcw_score_install_plugin() {
        $series = array(
                        'post_title'    => wp_strip_all_tags( 'Series' ),
                        'post_content'  => '[series]',
                        'post_status'   => 'publish',
                        'post_author'   => 1,
                        'post_type'     => 'page',
                      );
        $fixtures = array(
                          'post_title'    => wp_strip_all_tags( 'Live Cricket Scores' ),
                          'post_content'  => '[lcw-fixtures]',
                          'post_status'   => 'publish',
                          'post_author'   => 1,
                          'post_type'     => 'page',
                        );
        $series_match = array(
                              'post_title'    => wp_strip_all_tags( 'Matches' ),
                              'post_content'  => '[series-matches]',
                              'post_status'   => 'publish',
                              'post_author'   => 1,
                              'post_type'     => 'page',
                            );
        $match_detail = array(
                              'post_title'    => wp_strip_all_tags( 'Match Center' ),
                              'post_content'  => '[match-detail]',
                              'post_status'   => 'publish',
                              'post_author'   => 1,
                              'post_type'     => 'page',
                            );
        $player_stats = array(
                              'post_title'    => wp_strip_all_tags( 'Player Stats' ),
                              'post_content'  => '[player-stats]',
                              'post_status'   => 'publish',
                              'post_author'   => 1,
                              'post_type'     => 'page',
                            );
        $team_rank = array(
                              'post_title'    => wp_strip_all_tags( 'Team Rank' ),
                              'post_content'  => '[lcw-rankings]',
                              'post_status'   => 'publish',
                              'post_author'   => 1,
                              'post_type'     => 'page',
                            );
        $teams = array(
                              'post_title'    => wp_strip_all_tags( 'Teams' ),
                              'post_content'  => '[lcw-teams]',
                              'post_status'   => 'publish',
                              'post_author'   => 1,
                              'post_type'     => 'page',
                            );
        if( !post_exists ( wp_strip_all_tags( 'Series' ) ) ){
          
          wp_insert_post($series);
        }
        if( !post_exists ( wp_strip_all_tags( 'Live Cricket Scores' ) ) ){
          
          wp_insert_post($fixtures);
        }
        if( !post_exists ( wp_strip_all_tags( 'Matches' ) ) ){
          
          wp_insert_post($series_match);
        }
        
        if( !post_exists ( wp_strip_all_tags( 'Match Center' ) ) ){

          wp_insert_post($match_detail);
        }
        if( !post_exists ( wp_strip_all_tags( 'Player Stats' ) ) ){

          wp_insert_post( $player_stats );
        }
        if( !post_exists ( wp_strip_all_tags( 'Team Rank' ) ) ){

          wp_insert_post( $team_rank );
        }
        if( !post_exists ( wp_strip_all_tags( 'Teams' ) ) ){

          wp_insert_post( $teams );
        }
        update_option( 'col_per_row',  4 );
        update_option( 'series-layout',  3 );
        flush_rewrite_rules();
      }
      
      /**
       * Delete options after activate plugin
       *
       * @access public
       * @param void
       * @return void
       * @since 1.0.0
      */ 
      public static function lcw_score_uninstall_plugin() {


      }
  }
}