<?php

class LCW_series_Widget extends WP_Widget {

	/**
	 * Sets up the widgets name etc
	 */
	public function __construct() {
		$widget_ops = array( 
			'classname'   => 'lcw_series_widget',
			'description' => 'All Series',
		);
		parent::__construct( 'lcw_series_widget', 'All Series', $widget_ops );
	}

	/**
	 * Outputs the content of the widget
	 *
	 * @param array $args
	 * @param array $instance
	 */
	public function widget( $args, $instance ) {

		
		global $live_score;
		if(!is_page('match-detail')){

			$content        = $live_score->lcw_get_content('series?format=json');
	        $contents       = utf8_encode($content); 
	        $series         = json_decode($contents);
	        ?>
	        <div class="jeg_block_heading jeg_block_heading_6">
	        	<h3 class="jeg_block_title">
	        		<span>LIVE CRICKET SCORES (YOUR TIME) </span>
				</h3>
		</div>
	        	<select id="series-select">
	        	<option value="feature">Featured Matches</option>   		
	        <?php
	        if( !empty( $series ) ){

	              $series_list    = $series->seriesList->series;
	              foreach ($series_list as $single_series) {
	        ?>
					<option value="<?php echo $single_series->id; ?>"><?php echo $single_series->name; ?></option>
			<?php 

				}

			?>
				</select>
			<?php } ?>
				<div class="series-matches">
				<?php
					$matches_content        = $live_score->lcw_get_content('matches?inProgressLimit=2&upcomingLimit=2&completedLimit=1&format=json');
		          	$matches_contents       = utf8_encode( $matches_content ); 
		          	$matches_list   = json_decode( $matches_contents);
		              
		          	$matches        = $matches_list->matchList->matches;
		          	$i = 0;
		          	foreach ( $matches as $match ) {

		            	$status      = strtolower( $match->status );
		          ?>
		          <?php if($i%2 == 1): ?>
		          <script async src="//pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
					<ins class="adsbygoogle"
					     style="display:block"
					     data-ad-format="fluid"
					     data-ad-layout-key="-gp-e+1c-4d+81"
					     data-ad-client="ca-pub-4129522080154576"
					     data-ad-slot="4020595438"></ins>
					<script>
					     (adsbygoogle = window.adsbygoogle || []).push({});
					</script>
				<?php endif; ?>
	            <a class="keeda_cricket_match_link" href="<?php echo home_url('match-center/'.strtolower( str_replace(' ', '-', $match->awayTeam->name )).'-vs-'.strtolower( str_replace(' ', '-', $match->homeTeam->name )).'/'.$match->series->id.'/'.$match->id.'/'.$status.'/?view=summary'); ?>">
	            <div class="keeda_cricket_single_match">
	              <div class="keeda_cricket_match_list post">
	                <div class="keeda_widget_info cricket">
	                  	<?php echo $match->name ?> | <?php echo date('d F',strtotime( $match->startDateTime ) ).' '; 
		                    if( isset( $_COOKIE['timezone'] ) ){

		                        $arr = $live_score->lcw_get_user_timezone( $match->startDateTime,'h:i A');
		                        echo $arr;
		                      
		                    }else{

		                        echo date('h:i A',strtotime( $match->startDateTime ) );
		                    }
		                ?>
	                </div>
	                <div class="keeda_widget_team_group">
	                  <div class="keeda_widget_team">
	                      <i class="sprite sprite-<?php echo strtolower($match->awayTeam->shortName)?>"></i>
	                      <span class="keeda_widget_team_name cricket"><?php echo  $match->awayTeam->name ?> </span>
	                      <span class="keeda_widget_score cricket pull-right">
	                        <?php 
	                            if(isset($match->scores->awayScore)){
	                                 echo $match->scores->awayScore ?>(<?php echo $match->scores->awayOvers ?>)
	                                <?php
	                            }else{

	                                //echo "0-0(0)";

	                            }
	                        ?>
	                          
	                      </span>
	                  </div>
	                  <div class="keeda_widget_team">
	                    <i class="sprite sprite-<?php echo strtolower($match->homeTeam->shortName)?>"></i>
	                    <span class="keeda_widget_team_name cricket">

	                      <?php echo $match->homeTeam->name ?>
	                      
	                    </span>
	                    <span class="keeda_widget_score cricket pull-right">
	                      <?php 
	                          if(isset($match->scores->homeScore)){
	                                echo $match->scores->homeScore ?>(<?php echo $match->scores->homeOvers ?>)
	                              <?php
	                          }else{

	                              //echo "0-0(0)";

	                          }
	                      ?>
	                        
	                    </span>
	                  </div>
	                </div>
	                <div class="keeda_widget_result_info post">
	                  <span><?php echo $match->currentMatchState ?></span>
	                </div>
	              </div>
	              </div>
	            </a>
            <?php
        		$i++;	
        		}
          		
          	?>
			</div>
		<?php  
			}
		}

	/**
	 * Outputs the options form on admin
	 *
	 * @param array $instance The widget options
	 */
	public function form( $instance ) {
		
	}

	/**
	 * Processing widget options on save
	 *
	 * @param array $new_instance The new options
	 * @param array $old_instance The previous options
	 */
	public function update( $new_instance, $old_instance ) {
		
	}
}