<?php
foreach ($matches as $newSchedule) {

  $series_name = str_replace( " ", "-", str_replace( ",","",strtolower( $newSchedule->seriesName ) ) );
?>
<div class="ulcwp-series-wrap">
  	<div class="ulcwp-series-card">
	  	<a href="<?php echo home_url($series_name.'/'.$newSchedule->seriesID.'/matches' )?>">
			<div class="ulcwp-series-header">
			    <div class="ulcwp-series-name">
			      <h4><?php echo $newSchedule->seriesName ?></h4>
			    </div>
			    <div class="ulcwp-series-link">
			      
			        <svg xmlns="http://www.w3.org/2000/svg" fill="#4F525E" viewBox="0 0 10 8" width="16" height="16">
			          <path d="M9.840,3.626 L6.229,0.153 C6.126,0.054 5.988,-0.000 5.842,-0.000 C5.695,-0.000 5.558,0.054 5.455,0.153 L5.127,0.469 C5.024,0.567 4.967,0.699 4.967,0.841 C4.967,0.982 5.024,1.118 5.127,1.217 L7.234,3.248 L0.540,3.248 C0.238,3.248 -0.000,3.475 -0.000,3.765 L-0.000,4.211 C-0.000,4.501 0.238,4.751 0.540,4.751 L7.258,4.751 L5.127,6.793 C5.024,6.892 4.967,7.021 4.967,7.162 C4.967,7.303 5.024,7.433 5.127,7.532 L5.455,7.847 C5.558,7.946 5.695,8.000 5.842,8.000 C5.988,8.000 6.126,7.945 6.229,7.846 L9.840,4.373 C9.944,4.274 10.001,4.141 10.000,4.000 C10.000,3.858 9.944,3.725 9.840,3.626 Z"/>
			        </svg>
			      
			    </div>
			</div>
		</a>
	  	<div class="ulcwp-series-card-content">
		    <div class="row">  
				<?php
				foreach ($newSchedule->matches as $match) {
				  
				  $status      = strtolower( $match->matchStatus );

				?> 
				<a href="<?php echo home_url('live-score/'.strtolower( $match->homeTeamName ).'-vs-'.strtolower( $match->awayTeamName ).'-'.str_replace(' ', '-', strtolower($match->matchNumber)).'/'.$match->matchID.'/'.$status.'/?view=summary'); ?>">
				    <div class="col-md-4">
				          <div class="ulcwp-fixtures-data">
				            <div class="ulcwp-fixtures-data-head">
				              <h4> 
				                <?php echo !empty($match->matchNumber)? $match->matchNumber.', ' : ''; ?>
				                <?php echo !empty( $match->venue ) ? $match->venue.',': '' ?> 
				                  <small>
				                  	<?php 

	                                    $datetimeFormat = 'F d, Y, h:i A';

	                                    //$date = new \DateTime();
	                                    // If you must have use time zones
	                                    $date = new \DateTime('now', new DateTimeZone('UTC') );

	                                    $loc = (new DateTime)->getTimezone();

	                                    // change the timezone of the object without changing its time
	                                    $date->setTimezone($loc);
	                                    //echo substr($single_series->seriesStartDate, 0, -3);
	                                    $date->setTimestamp(substr($match->startDate, 0, -3));
	                                    
	                                    echo $date->format($datetimeFormat);
                                  	?>
				                  </small>
				                </h4>
				              	
				            </div>
				            <div class="ulcwp-fixtures-data-card">
				              <?php 
				                $i = 0;
				                foreach ($match->matchScore as $score) {
				            ?>
				              <div class="ulcwp-match-team-data">
				                <div class="ulcwp-match-team-info ulcwp-d-flex ulcwp-justify-content-between ulcwp-align-items-center">
				                  <div class="ulcwp-team-name">
				                    <div class="ulcwp-team-col ulcwp-d-flex ulcwp-align-items-center">
				                      <span class="ulcwp-team-img">
				                       <img src="https://images.cricket.com/teams/<?php echo $score->teamID ?>_flag_safari.png" alt=""  onerror="this.onerror=null;this.src='https://www.cricket.com/svgs/images/flag_empty.svg';">
				                      </span>
				                      
			                        <span class="ulcwp-team-longname"><?php echo $score->teamShortName; ?></span>
			                        <span class="ulcwp-team-shortname"><?php echo $score->teamShortName; ?></span>
			                      
				                    </div>
				                  </div>
				                  <div class="ulcwp-team-score">
				                    <?php 
				                      foreach ($score->teamScore as $teamscore) {
				                          
				                          echo $teamscore->runsScored.'/'. $teamscore->wickets.'<span>('. $teamscore->overs. 'ov)</span>';
				                        }
				                    ?>
				                    </div>
				                </div>
				              </div>
				            <?php } ?>  
				              <div class="ulcwp-match-info">
				                <p><?php echo $match->statusMessage; ?>.</p>
				                <?php 
                                  if($status == "upcoming"){
                                
                                    $now = time(); // or your date as well
                                    $your_date = substr($match->startDate, 0, -3);
                                    //echo $your_date;
                                    $datediff = $your_date - $now;
                                    $daystogo = round($datediff / (60 * 60 * 24));
                                    if($daystogo == 0){
                                      
                                      $date = new \DateTime('now', new DateTimeZone('UTC') );

                                      $loc = (new DateTime)->getTimezone();

                                      // change the timezone of the object without changing its time
                                      $date->setTimezone($loc);
                                    //echo substr($single_series->seriesStartDate, 0, -3);
                                    $date->setTimestamp(substr($match->startDate, 0, -3));
                                      echo '<span class="badge">Today </span>';
                                      
                                    }else{
                                      
                                      echo '<span class="badge">'.$daystogo." Days to go</span>";
                                    }
                                  }
                                ?>
				              </div>
				              <?php if(!empty($match->teamsWinProbability->homeTeamPercentage) && $match->matchStatus != 'completed'): ?>
				              <div class="ulcwp-match-prediction">
				                <div class="ulcwp-match-prediction-top ulcwp-d-flex">
				                  <div class="ulcwp-team-prediction-1" style="width: <?php echo $match->teamsWinProbability->homeTeamPercentage ?>%"></div>
				                  <div class="ulcwp-prediction-draw" style="width: <?php echo $match->teamsWinProbability->tiePercentage ?>%"></div>
				                  <div class="ulcwp-team-prediction-2" style="width: <?php echo $match->teamsWinProbability->awayTeamPercentage ?>%"></div>
				                </div>
				                <div class="ulcwp-match-prediction-bottom ulcwp-d-flex ulcwp-justify-content-between">
				                  <div class="ulcwp-prediction-name ulcwp-d-flex ulcwp-align-items-center">
				                    <span class="ulcwp-team-prediction-1"></span>
				                    <p><?php echo $match->teamsWinProbability->homeTeamShortName ?> <span><?php echo $match->teamsWinProbability->homeTeamPercentage ?>%</span></p>
				                  </div>
				                  <div class="ulcwp-prediction-name ulcwp-d-flex ulcwp-align-items-center">
				                    <span class="ulcwp-prediction-draw"></span>
				                    <p>Tie <span><?php echo $match->teamsWinProbability->tiePercentage ?>%</span></p>
				                  </div>
				                  <div class="ulcwp-prediction-name ulcwp-d-flex ulcwp-align-items-center">
				                    <span class="ulcwp-team-prediction-2"></span>
				                    <p><?php echo $match->teamsWinProbability->awayTeamShortName ?> <span><?php echo $match->teamsWinProbability->awayTeamPercentage ?>%</span></p>
				                  </div>
				                </div>
				              </div>
				            <?php endif; ?>
				            </div>  
				          </div>
				    </div>
				</a>
				<?php
				}
				?>
			</div>
		</div>
	</div>
</div>
<?php } ?>
