<?php
function lcw_load_upcomming_matches( $matches ){
  global $live_score;
  //print_r($matches);
  ob_start();
  
  if(isset($matches) && !empty($matches)){

    ?>
    <div class="row display-flex">
    <?php
    
      foreach ($matches as $match) { 
        
        $status      = strtolower( $match->matchStatus );
         
    ?>
        <div class="col-md-4 col-sm-12 col-xs-12 ulcwp-match-wrap">
            <a href="<?php echo home_url('live-score/'.strtolower( $match->homeTeamShortName ).'-vs-'.strtolower( $match->awayTeamShortName ).'-'.str_replace(' ', '-', strtolower($match->matchNumber)).'/'.$match->matchID.'/'.$status.'/?view=summary'); ?>">
              <div class="ulcwp-fixtures-data">
                <div class="ulcwp-fixtures-data-head">
                  <h4> 
                    <?php echo !empty($match->matchNumber)? $match->matchNumber.', ' : ''; ?>
                    <?php echo !empty( $match->venue ) ? $match->venue.',': '' ?> 
                      
                        <?php 

                          $datetimeFormat = 'F d, Y, h:i A';

                          //$date = new \DateTime();
                          // If you must have use time zones
                          $date = new \DateTime('now', new DateTimeZone('UTC') );

                          $loc = (new DateTime)->getTimezone();

                          // change the timezone of the object without changing its time
                          $date->setTimezone($loc);
                          //echo substr($single_series->seriesStartDate, 0, -3);
                          $date->setTimestamp(substr($match->startDate, 0, -3));
                          
                          echo $date->format($datetimeFormat);
                        ?>
                      
                    </h4>
                </div>
                <div class="ulcwp-fixtures-data-card">
                  <?php 
                    $i = 0;
                    
                    foreach ($match->matchScore as $score) {

                      if( $match->winningTeamID != $score->teamID && !empty( $match->winningTeamID ) ){

                          $cls = "ulcwp-opacity-50";

                      }elseif( $match->winningTeamID == "" ){

                        $cls = "";

                      }else{
                        
                        $cls = "";
                      }
                     
                ?>
                  <div class="ulcwp-match-team-data <?php echo $match->matchStatus == 'completed' ? $cls : '' ?>">
                    <div class="ulcwp-match-team-info ulcwp-d-flex ulcwp-justify-content-between ulcwp-align-items-center">
                      <div class="ulcwp-team-name">
                        <div class="ulcwp-team-col ulcwp-d-flex ulcwp-align-items-center">
                          <span class="ulcwp-team-img">
                            <?php 
                              //echo LCW_LIVE_SCORE_ROOT_PATH.'/images/teams-flag/'.$score->teamID.'.jpg' ;
                                if(file_exists(LCW_LIVE_SCORE_ROOT_PATH.'/images/teams-flag/'.$score->teamID.'.jpg' ) ){
                              ?>
                                <img src="<?php echo plugins_url( 'images/teams-flag/'.$score->teamID.'.jpg' , dirname(__FILE__) );?>" alt=""  onerror="this.onerror=null;this.src='https://www.cricket.com/svgs/images/flag_empty.svg';">
                              <?php  
                                }else{ 
                              ?>
                                <img src="https://images.cricket.com/teams/<?php echo $score->teamID ?>_flag_safari.png" alt=""  onerror="this.onerror=null;this.src='https://www.cricket.com/svgs/images/flag_empty.svg';">
                              <?php } ?>
                          </span>
                          <span class="ulcwp-team-longname"><?php   echo $score->teamShortName; ?></span>
                          <span class="ulcwp-team-shortname"><?php  echo $score->teamShortName; ?></span>
                        </div>
                      </div>
                      <div class="ulcwp-team-score">
                        <?php 
                          $i = 0;
                          foreach ($score->teamScore as $teamscore) {
                              
                            echo $teamscore->runsScored.'/'. $teamscore->wickets.'<span>('. $teamscore->overs. 'ov)</span>';

                            if( $match->matchType == "Test" ){

                                if ( $i < count($score->teamScore)-1) {
                                    
                                    echo " & ";
                                }    
                            }
                            $i++;

                          }
                        ?>
                        </div>
                    </div>
                  </div>
                <?php } ?>  
                  <div class="ulcwp-match-info">
                    <p><?php echo $match->statusMessage; ?></p>
                    <?php 
                      if($status == "upcoming"){
                    
                        $now = time(); // or your date as well
                        $your_date = substr($match->startDate, 0, -3);
                        //echo $your_date;
                        $datediff = $your_date - $now;
                        $daystogo = round($datediff / (60 * 60 * 24));
                        if($daystogo == 0){

                          $date = new \DateTime('now', new DateTimeZone('UTC') );

                          $loc = (new DateTime)->getTimezone();

                          // change the timezone of the object without changing its time
                          $date->setTimezone($loc);
                        //echo substr($single_series->seriesStartDate, 0, -3);
                        $date->setTimestamp(substr($match->startDate, 0, -3));
                          echo '<span class="badge">Today </span>';
                          
                        }else{
                          
                          echo '<span class="badge">'.$daystogo." Days to go</span>";
                        }
                      }
                    ?>
                  </div>
                  <?php if(!empty($match->teamsWinProbability->homeTeamPercentage) && $status != 'completed'){ ?>
                  <div class="ulcwp-match-prediction">
                    <div class="ulcwp-match-prediction-top ulcwp-d-flex">
                      <div class="ulcwp-team-prediction-1" style="width: <?php echo $match->teamsWinProbability->homeTeamPercentage ?>%"></div>
                      <div class="ulcwp-prediction-draw" style="width: <?php echo $match->teamsWinProbability->tiePercentage ?>%"></div>
                      <div class="ulcwp-team-prediction-2" style="width: <?php echo $match->teamsWinProbability->awayTeamPercentage ?>%"></div>
                    </div>
                    <div class="ulcwp-match-prediction-bottom ulcwp-d-flex ulcwp-justify-content-between">
                      <div class="ulcwp-prediction-name ulcwp-d-flex ulcwp-align-items-center">
                        <span class="ulcwp-team-prediction-1"></span>
                        <p><?php echo $match->teamsWinProbability->homeTeamShortName ?> <span><?php echo $match->teamsWinProbability->homeTeamPercentage ?>%</span></p>
                      </div>
                      <div class="ulcwp-prediction-name ulcwp-d-flex ulcwp-align-items-center">
                        <span class="ulcwp-prediction-draw"></span>
                        <p>Tie <span><?php echo $match->teamsWinProbability->tiePercentage ?>%</span></p>
                      </div>
                      <div class="ulcwp-prediction-name ulcwp-d-flex ulcwp-align-items-center">
                        <span class="ulcwp-team-prediction-2"></span>
                        <p><?php echo $match->teamsWinProbability->awayTeamShortName ?> <span><?php echo $match->teamsWinProbability->awayTeamPercentage ?>%</span></p>
                      </div>
                    </div>
                  </div>
                <?php }elseif( $status == 'completed'){ 
                    echo "<div></div>";
                }else { ?>
                  <div class="update-soon"><img src="<?php echo plugins_url( 'images/waiting.png', dirname(__FILE__) ) ?>"> Win Projections to be updated soon</div>
                <?php 
                  } 
                ?>
                </div>  
              </div>
            </a>
        </div>
      
    <?php
        
        }
    ?>
    </div> 
<?php 
  }
    $content = ob_get_clean();
    return $content; 
}